/// <reference path="./internal_*.d.ts" />
declare namespace net.minecraft.world.level.pathfinder {
    class Path {
        constructor($$0: Internal.List_<Internal.Node>, $$1: BlockPos_, $$2: boolean)
        getEntityPosAtNode($$0: Internal.Entity_, $$1: number): Vec3d;
        getNextEntityPos($$0: Internal.Entity_): Vec3d;
        notStarted(): boolean;
        getEndNode(): Internal.Node;
        canReach(): boolean;
        replaceNode($$0: number, $$1: Internal.Node_): void;
        getNextNodeIndex(): number;
        getPreviousNode(): Internal.Node;
        getNode($$0: number): Internal.Node;
        isDone(): boolean;
        static createFromStream($$0: Internal.FriendlyByteBuf_): net.minecraft.world.level.pathfinder.Path;
        getClosedSet(): Internal.Node[];
        getNodePos($$0: number): BlockPos;
        advance(): void;
        writeToStream($$0: Internal.FriendlyByteBuf_): void;
        getNextNode(): Internal.Node;
        getNodeCount(): number;
        sameAs($$0: net.minecraft.world.level.pathfinder.Path_): boolean;
        getOpenSet(): Internal.Node[];
        setNextNodeIndex($$0: number): void;
        getNextNodePos(): BlockPos;
        getTarget(): BlockPos;
        getDistToTarget(): number;
        truncateNodes($$0: number): void;
        get endNode(): Internal.Node
        get nextNodeIndex(): number
        get previousNode(): Internal.Node
        get done(): boolean
        get closedSet(): Internal.Node[]
        get nextNode(): Internal.Node
        get nodeCount(): number
        get openSet(): Internal.Node[]
        set nextNodeIndex($$0: number)
        get nextNodePos(): BlockPos
        get target(): BlockPos
        get distToTarget(): number
    }
    type Path_ = Path;
}
declare namespace Internal {
    class ChannelMode extends Internal.Enum<Internal.ChannelMode> {
        static valueOf(name: string): Internal.ChannelMode;
        getAdHocNetworkChannels(): number;
        static values(): Internal.ChannelMode[];
        getCableCapacityFactor(): number;
        get adHocNetworkChannels(): number
        get cableCapacityFactor(): number
        static readonly DEFAULT: Internal.ChannelMode;
        static readonly X2: Internal.ChannelMode;
        static readonly X4: Internal.ChannelMode;
        static readonly X3: Internal.ChannelMode;
        static readonly INFINITE: Internal.ChannelMode;
    }
    type ChannelMode_ = "x3" | "x4" | "infinite" | "x2" | ChannelMode | "default";
    class BlockHexSlab extends Internal.SlabBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        isFlammable(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getFireSpreadSpeed(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): number;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getFlammability(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockHexSlab_ = BlockHexSlab;
    interface ArgumentTypeInfo$Template <A extends Internal.ArgumentType<any>> {
        abstract type(): Internal.ArgumentTypeInfo<A, any>;
        abstract instantiate(arg0: Internal.CommandBuildContext_): A;
    }
    type ArgumentTypeInfo$Template_<A extends Internal.ArgumentType<any>> = ArgumentTypeInfo$Template<A>;
    class SwordItem extends Internal.TieredItem implements Internal.Vanishable, Internal.VanillaToolActionItem, Internal.ModifiableItemKJS {
        constructor($$0: Internal.Tier_, $$1: number, $$2: number, $$3: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        port_lib$canPerformAction(stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getDamage(): number;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get damage(): number
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        defaultModifiers: Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
    }
    type SwordItem_ = SwordItem;
    interface EntityAccessor {
        abstract catnip$callSetLevel(arg0: Internal.Level_): void;
        (arg0: Internal.Level): void;
    }
    type EntityAccessor_ = EntityAccessor;
    class UpgradeData {
        constructor($$0: Internal.CompoundTag_, $$1: Internal.LevelHeightAccessor_)
        upgrade($$0: Internal.LevelChunk_): void;
        write(): Internal.CompoundTag;
        isEmpty(): boolean;
        get empty(): boolean
        static readonly EMPTY: Internal.UpgradeData;
    }
    type UpgradeData_ = UpgradeData;
    interface LootTableSubProvider {
        abstract generate(arg0: Internal.BiConsumer_<ResourceLocation, Internal.LootTable$Builder>): void;
        (arg0: Internal.BiConsumer<ResourceLocation, Internal.LootTable$Builder>): void;
    }
    type LootTableSubProvider_ = LootTableSubProvider;
    interface BasicFileAttributes {
        abstract isRegularFile(): boolean;
        abstract creationTime(): Internal.FileTime;
        abstract isSymbolicLink(): boolean;
        abstract isOther(): boolean;
        abstract fileKey(): any;
        abstract isDirectory(): boolean;
        abstract size(): number;
        abstract lastModifiedTime(): Internal.FileTime;
        abstract lastAccessTime(): Internal.FileTime;
        get regularFile(): boolean
        get symbolicLink(): boolean
        get other(): boolean
        get directory(): boolean
    }
    type BasicFileAttributes_ = BasicFileAttributes;
    interface ITinkerStationContainer extends Internal.ITinkerableContainer {
        stopOpen($$0: Internal.Player_): void;
        tryClear($$0: any): void;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        /**
         * @deprecated
        */
        removeItem(index: number, count: number): Internal.ItemStack;
        getSlots(): number;
        /**
         * @deprecated
        */
        setChanged(): void;
        /**
         * @deprecated
        */
        getContainerSize(): number;
        /**
         * @deprecated
        */
        setItem(index: number, stack: Internal.ItemStack_): void;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        abstract getTinkerableStack(): Internal.ItemStack;
        /**
         * @deprecated
        */
        removeItemNoUpdate(index: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        getTinkerable(): Internal.ToolStack;
        /**
         * @deprecated
        */
        getItem(index: number): Internal.ItemStack;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        isEmpty(): boolean;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        getHeight(): number;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        getAllItems(): Internal.List<Internal.ItemStack>;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        stillValid(player: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        abstract getInputCount(): number;
        abstract getInputMaterial(arg0: number): Internal.MaterialRecipe;
        isMutable(): boolean;
        clear(): void;
        abstract getInput(arg0: number): Internal.ItemStack;
        find(ingredient: Internal.Ingredient_): number;
        /**
         * @deprecated
        */
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get slots(): number
        /**
         * @deprecated
        */
        get containerSize(): number
        get width(): number
        get maxStackSize(): number
        get tinkerableStack(): Internal.ItemStack
        get tinkerable(): Internal.ToolStack
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get inputCount(): number
        get mutable(): boolean
    }
    type ITinkerStationContainer_ = ITinkerStationContainer;
    interface Channel$Unsafe {
        abstract localAddress(): Internal.SocketAddress;
        abstract deregister(arg0: Internal.ChannelPromise_): void;
        abstract recvBufAllocHandle(): Internal.RecvByteBufAllocator$Handle;
        abstract closeForcibly(): void;
        abstract close(arg0: Internal.ChannelPromise_): void;
        abstract beginRead(): void;
        abstract outboundBuffer(): Internal.ChannelOutboundBuffer;
        abstract connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_, arg2: Internal.ChannelPromise_): void;
        abstract flush(): void;
        abstract bind(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): void;
        abstract register(arg0: Internal.EventLoop_, arg1: Internal.ChannelPromise_): void;
        abstract disconnect(arg0: Internal.ChannelPromise_): void;
        abstract write(arg0: any, arg1: Internal.ChannelPromise_): void;
        abstract remoteAddress(): Internal.SocketAddress;
        abstract voidPromise(): Internal.ChannelPromise;
    }
    type Channel$Unsafe_ = Channel$Unsafe;
    class RemoveWorldgenEventJS extends Internal.StartupEventJS {
        constructor()
        printFiltered(): void;
        removeSpawns(p: Internal.Consumer_<Internal.RemoveSpawnsProperties>): void;
        removeAllFeatures(filter: Internal.BiomeFilter_): void;
        printSpawns(category: Internal.MobCategory_): void;
        printFeatures(type: Internal.GenerationStep$Decoration_): void;
        removeAllFeatures(): void;
        removeAllSpawns(): void;
        removeOres(p: Internal.Consumer_<Internal.RemoveOresProperties>): void;
        printSpawns(): void;
        removeFeatureById(filter: Internal.BiomeFilter_, decoration: Internal.GenerationStep$Decoration_, ids: ResourceLocation_[]): void;
        printFeatures(type: Internal.GenerationStep$Decoration_, filter: Internal.BiomeFilter_): void;
        printFiltered(type: Internal.GenerationStep$Decoration_): void;
        printFeaturesForType(type: Internal.GenerationStep$Decoration_, filter: Internal.BiomeFilter_, afterRemoval: boolean): void;
        removeAllFeatures(filter: Internal.BiomeFilter_, type: Internal.GenerationStep$Decoration_): void;
        removeFeatureById(type: Internal.GenerationStep$Decoration_, ids: ResourceLocation_[]): void;
        printFiltered(type: Internal.GenerationStep$Decoration_, filter: Internal.BiomeFilter_): void;
        printFeatures(): void;
    }
    type RemoveWorldgenEventJS_ = RemoveWorldgenEventJS;
    class HashBiMap <K, V> extends Internal.Maps$IteratorBasedAbstractMap<K, V> implements Internal.BiMap<K, V>, Internal.Serializable {
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        static create<K, V>(arg0: number): Internal.HashBiMap<K, V>;
        static of<K, V>(): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        getOrDefault(arg0: any, arg1: V): V;
        inverse(): Internal.BiMap<V, K>;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        put(arg0: K, arg1: V): V;
        get(arg0: any): V;
        remove(arg0: any): V;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        values(): Internal.Collection<any>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        keySet(): Internal.Set<K>;
        putIfAbsent(arg0: K, arg1: V): V;
        entrySet(): Internal.Set<any>;
        static create<K, V>(arg0: Internal.Map_<K, V>): Internal.HashBiMap<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static create<K, V>(): Internal.HashBiMap<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        forcePut(arg0: K, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type HashBiMap_<K, V> = HashBiMap<K, V>;
    interface FluidRenderHandlerMixin extends Internal.FluidRenderHandlerExtension {
        getFluidModel(): Internal.FluidBakedModel;
        get fluidModel(): Internal.FluidBakedModel
    }
    type FluidRenderHandlerMixin_ = FluidRenderHandlerMixin;
    interface AccessorFontManager {
        abstract bookshelf$getFonts(): Internal.Map<ResourceLocation, Internal.FontSet>;
        (): Internal.Map_<ResourceLocation, Internal.FontSet>;
    }
    type AccessorFontManager_ = AccessorFontManager;
    class MultiPartBlockStateBuilder$PartBuilder {
        constructor(this$0: Internal.MultiPartBlockStateBuilder_, models: Internal.BlockStateProvider$ConfiguredModelList_)
        useOr(): this;
        condition<T extends Internal.Comparable<T>>(prop: Internal.Property_<T>, ...values: T[]): this;
        nestedGroup(): Internal.MultiPartBlockStateBuilder$PartBuilder$ConditionGroup;
        canApplyTo(b: Internal.Block_): boolean;
        end(): Internal.MultiPartBlockStateBuilder;
        readonly conditions: Internal.Multimap<Internal.Property<any>, Internal.Comparable<any>>;
        models: Internal.BlockStateProvider$ConfiguredModelList;
        useOr: boolean;
        readonly nestedConditionGroups: Internal.List<Internal.MultiPartBlockStateBuilder$PartBuilder$ConditionGroup>;
    }
    type MultiPartBlockStateBuilder$PartBuilder_ = MultiPartBlockStateBuilder$PartBuilder;
    interface LootItemFunction extends Internal.LootContextUser, Internal.BiFunction<Internal.ItemStack, Internal.LootContext, Internal.ItemStack> {
        decorate($$0: Internal.BiFunction_<Internal.ItemStack, Internal.LootContext, Internal.ItemStack>, $$1: Internal.Consumer_<Internal.ItemStack>, $$2: Internal.LootContext_): Internal.Consumer<Internal.ItemStack>;
        andThen<V>(arg0: Internal.Function_<Internal.ItemStack, V>): Internal.BiFunction<Internal.ItemStack, Internal.LootContext, V>;
        abstract apply(arg0: Internal.ItemStack_, arg1: Internal.LootContext_): Internal.ItemStack;
        getReferencedContextParams(): Internal.Set<Internal.LootContextParam<any>>;
        validate($$0: Internal.ValidationContext_): void;
        abstract getType(): Internal.LootItemFunctionType;
        get referencedContextParams(): Internal.Set<Internal.LootContextParam<any>>
        get type(): Internal.LootItemFunctionType
    }
    type LootItemFunction_ = LootItemFunction;
    class Block extends Internal.BlockBehaviour implements Internal.FabricBlock, Internal.SophisticatedBlock, Internal.ItemLike, io.github.fabricators_of_create.porting_lib.extensions.extensions.BlockExtensions, Internal.InjectedBlockExtension, Internal.BlockAccessor, Internal.BlockExtensions {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getSoundType($$0: Internal.BlockState_): SoundType;
        static dropResources($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.BlockEntity_, $$4: Internal.Entity_, $$5: Internal.ItemStack_): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        static isFaceFull($$0: Internal.VoxelShape_, $$1: Internal.Direction_): boolean;
        static updateOrDestroy($$0: Internal.BlockState_, $$1: Internal.BlockState_, $$2: Internal.LevelAccessor_, $$3: BlockPos_, $$4: number, $$5: number): void;
        static dropResources($$0: Internal.BlockState_, $$1: Internal.LevelAccessor_, $$2: BlockPos_, $$3: Internal.BlockEntity_): void;
        static byItem($$0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes($$0: Internal.BlockState_, $$1: Internal.LevelAccessor_, $$2: BlockPos_): Internal.BlockState;
        static canSupportRigidBlock($$0: Internal.BlockGetter_, $$1: BlockPos_): boolean;
        destroy($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): void;
        static popResource($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.ItemStack_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getDescriptionId(): string;
        stepOn($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Entity_): void;
        fallOn($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: BlockPos_, $$3: Internal.Entity_, $$4: number): void;
        static dropResources($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_): void;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getExplosionResistance(): number;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement($$0: Internal.BlockPlaceContext_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getJumpFactor(): number;
        getSpeedFactor(): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        static canSupportCenter($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.Direction_): boolean;
        playerDestroy($$0: Internal.Level_, $$1: Internal.Player_, $$2: BlockPos_, $$3: Internal.BlockState_, $$4: Internal.BlockEntity_, $$5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis($$0: Internal.BlockState_): boolean;
        getCloneItemStack($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        playerWillDestroy($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Player_): void;
        hasDynamicShape(): boolean;
        emi(): Internal.EmiStack;
        dropFromExplosion($$0: Internal.Explosion_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        isRandomlyTicking($$0: Internal.BlockState_): boolean;
        withPropertiesOf($$0: Internal.BlockState_): Internal.BlockState;
        static isExceptionForConnection($$0: Internal.BlockState_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        appendHoverText($$0: Internal.ItemStack_, $$1: Internal.BlockGetter_, $$2: Internal.List_<net.minecraft.network.chat.Component>, $$3: Internal.TooltipFlag_): void;
        static box($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): Internal.VoxelShape;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        wasExploded($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        setRequiresTool(v: boolean): void;
        updateEntityAfterFallOn($$0: Internal.BlockGetter_, $$1: Internal.Entity_): void;
        animateTick($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        static updateOrDestroy($$0: Internal.BlockState_, $$1: Internal.BlockState_, $$2: Internal.LevelAccessor_, $$3: BlockPos_, $$4: number): void;
        port_lib$popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        static stateById($$0: number): Internal.BlockState;
        static getDrops($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.BlockEntity_, $$4: Internal.Entity_, $$5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        popExperience($$0: Internal.ServerLevel_, $$1: BlockPos_, $$2: number): void;
        propagatesSkylightDown($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): boolean;
        setPlacedBy($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.LivingEntity_, $$4: Internal.ItemStack_): void;
        emi(amount: number): Internal.EmiStack;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static getId($$0: Internal.BlockState_): number;
        static pushEntitiesUp($$0: Internal.BlockState_, $$1: Internal.BlockState_, $$2: Internal.LevelAccessor_, $$3: BlockPos_): Internal.BlockState;
        static popResourceFromFace($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.Direction_, $$3: Internal.ItemStack_): void;
        getFriction(): number;
        handlePrecipitation($$0: Internal.BlockState_, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.Biome$Precipitation_): void;
        static getDrops($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        static shouldRenderFace($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.Direction_, $$4: BlockPos_): boolean;
        set lightEmission(v: number)
        get descriptionId(): string
        set destroySpeed(v: number)
        get explosionResistance(): number
        get jumpFactor(): number
        get speedFactor(): number
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        get blockStates(): Internal.List<Internal.BlockState>
        get name(): Internal.MutableComponent
        set requiresTool(v: boolean)
        get mod(): string
        get friction(): number
        static readonly UPDATE_ALL_IMMEDIATE: 11;
        static readonly INDESTRUCTIBLE: -1.0;
        static readonly UPDATE_KNOWN_SHAPE: 16;
        static readonly UPDATE_IMMEDIATE: 8;
        static readonly UPDATE_SUPPRESS_DROPS: 32;
        static readonly UPDATE_ALL: 3;
        static readonly UPDATE_CLIENTS: 2;
        static readonly UPDATE_INVISIBLE: 4;
        static readonly UPDATE_LIMIT: 512;
        static readonly UPDATE_NONE: 4;
        static readonly INSTANT: 0.0;
        static readonly BLOCK_STATE_REGISTRY: Internal.IdMapper<Internal.BlockState>;
        static readonly UPDATE_NEIGHBORS: 1;
        static readonly UPDATE_MOVE_BY_PISTON: 64;
    }
    type Block_ = Special.Block | Block;
    class ShapedRecipeSpec extends Internal.Record {
        constructor(properties: Internal.RecipeProperties_, template: Internal.ShapedTemplate_, result: Internal.ItemStack_)
        properties(): Internal.RecipeProperties;
        static fromJson(json: Internal.JsonObject_): Internal.ShapedRecipeSpec;
        static fromNetwork(buffer: Internal.FriendlyByteBuf_): Internal.ShapedRecipeSpec;
        toNetwork(buffer: Internal.FriendlyByteBuf_): void;
        result(): Internal.ItemStack;
        template(): Internal.ShapedTemplate;
    }
    type ShapedRecipeSpec_ = ShapedRecipeSpec;
    interface RuleTestType <P extends Internal.RuleTest> {
        abstract codec(): Internal.Codec<P>;
        register<P extends Internal.RuleTest>($$0: string, $$1: Internal.Codec_<P>): this;
        (): Internal.Codec_<P>;
        readonly TAG_TEST: Internal.RuleTestType<Internal.TagMatchTest>;
        readonly RANDOM_BLOCKSTATE_TEST: Internal.RuleTestType<Internal.RandomBlockStateMatchTest>;
        readonly BLOCKSTATE_TEST: Internal.RuleTestType<Internal.BlockStateMatchTest>;
        readonly ALWAYS_TRUE_TEST: Internal.RuleTestType<Internal.AlwaysTrueTest>;
        readonly RANDOM_BLOCK_TEST: Internal.RuleTestType<Internal.RandomBlockMatchTest>;
        readonly BLOCK_TEST: Internal.RuleTestType<Internal.BlockMatchTest>;
    }
    type RuleTestType_<P extends Internal.RuleTest> = RuleTestType<P> | Special.RuleTest;
    class SlotGroup {
        getSlots(): Internal.Map<string, dev.emi.trinkets.api.SlotType>;
        getName(): string;
        static read(data: Internal.CompoundTag_): Internal.SlotGroup;
        getSlotId(): number;
        getOrder(): number;
        write(data: Internal.CompoundTag_): void;
        get slots(): Internal.Map<string, dev.emi.trinkets.api.SlotType>
        get name(): string
        get slotId(): number
        get order(): number
    }
    type SlotGroup_ = SlotGroup;
    interface FocusGained {
        newStream(): Internal.EventStream<Internal.FocusGained>;
        abstract onFocusGained(arg0: Internal.Component$FocusSource_): void;
        (arg0: Internal.Component$FocusSource): void;
    }
    type FocusGained_ = FocusGained;
    class SpawnDeathWorm extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(configFactoryIn: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type SpawnDeathWorm_ = SpawnDeathWorm;
    class EntityIota$1 extends Internal.IotaType<Internal.EntityIota> {
        deserialize(tag: Internal.Tag_, world: Internal.ServerLevel_): Internal.EntityIota;
    }
    type EntityIota$1_ = EntityIota$1;
    class SeagrassBlock extends Internal.BushBlock implements Internal.IShearable, Internal.LiquidBlockContainer, Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type SeagrassBlock_ = SeagrassBlock;
    class UploadInfo extends Internal.ValueObject {
        static assembleUri($$0: string, $$1: number): Internal.URI;
        static parse($$0: string): Internal.UploadInfo;
        getToken(): string;
        static createRequest($$0: string): string;
        getUploadEndpoint(): Internal.URI;
        isWorldClosed(): boolean;
        get token(): string
        get uploadEndpoint(): Internal.URI
        get worldClosed(): boolean
    }
    type UploadInfo_ = UploadInfo;
    class TinkerDataCapability$Holder implements dev.onyxstudios.cca.api.v3.component.Component {
        constructor()
        readFromNbt(compoundTag: Internal.CompoundTag_): void;
        remove(key: Internal.TinkerDataCapability$TinkerDataKey_<any>): void;
        get<T>(key: Internal.TinkerDataCapability$TinkerDataKey_<T>): T;
        computeIfAbsent<T, U extends Internal.TinkerDataCapability$TinkerDataKey<T> & Internal.Function<Internal.TinkerDataCapability$TinkerDataKey<any>, T>>(key: U): T;
        writeToNbt(compoundTag: Internal.CompoundTag_): void;
        get<S, T extends S>(key: Internal.TinkerDataCapability$TinkerDataKey_<T>, defaultValue: S): S;
        put<T>(key: Internal.TinkerDataCapability$TinkerDataKey_<T>, value: T): void;
        contains(key: Internal.TinkerDataCapability$TinkerDataKey_<any>): boolean;
    }
    type TinkerDataCapability$Holder_ = TinkerDataCapability$Holder;
    class BookRecipeSerializer <T extends Internal.Recipe<any>, U extends T> extends Internal.Record implements Internal.RecipeSerializer<U> {
        constructor(compose: Internal.RecipeSerializer_<T>, converter: Internal.BiFunction_<T, ResourceLocation, U>)
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromNetwork(id: ResourceLocation_, buf: Internal.FriendlyByteBuf_): U;
        compose(): Internal.RecipeSerializer<T>;
        converter(): Internal.BiFunction<T, ResourceLocation, U>;
        toNetwork(buf: Internal.FriendlyByteBuf_, recipe: U): void;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): U;
    }
    type BookRecipeSerializer_<T extends Internal.Recipe<any>, U extends T> = BookRecipeSerializer<T, U>;
    class FileTime implements Internal.Comparable<Internal.FileTime> {
        static from(arg0: number, arg1: Internal.TimeUnit_): Internal.FileTime;
        toMillis(): number;
        compareTo(arg0: Internal.FileTime_): number;
        toInstant(): Internal.Instant;
        to(arg0: Internal.TimeUnit_): number;
        static fromMillis(arg0: number): Internal.FileTime;
        compareTo(arg0: any): number;
        static from(arg0: Internal.Instant_): Internal.FileTime;
    }
    type FileTime_ = FileTime;
    class ClientboundSetChunkCacheRadiusPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getRadius(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get radius(): number
        get skippable(): boolean
    }
    type ClientboundSetChunkCacheRadiusPacket_ = ClientboundSetChunkCacheRadiusPacket;
    class PacketFlow extends Internal.Enum<Internal.PacketFlow> {
        getOpposite(): this;
        static values(): Internal.PacketFlow[];
        static valueOf($$0: string): Internal.PacketFlow;
        get opposite(): Internal.PacketFlow
        static readonly CLIENTBOUND: Internal.PacketFlow;
        static readonly SERVERBOUND: Internal.PacketFlow;
    }
    type PacketFlow_ = "serverbound" | "clientbound" | PacketFlow;
    interface CustomSoundTypeBlock {
        abstract getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        (arg0: Internal.BlockState, arg1: Internal.LevelReader, arg2: BlockPos, arg3: Internal.Entity): SoundType_;
    }
    type CustomSoundTypeBlock_ = CustomSoundTypeBlock;
    class ClientInitEventJS extends Internal.ClientEventJS {
        constructor()
        registerEntityRenderer(type: Internal.EntityType_<any>, renderer: Internal.EntityRendererProvider_<any>): void;
        registerMenuScreen(type: Internal.MenuType_<any>, screenFactory: Internal.MenuRegistry$ScreenFactory_<any, any>): void;
        getEntity(): Internal.Entity;
        registerBlockEntityRenderer(type: Internal.BlockEntityType_<any>, renderer: Internal.BlockEntityRendererProvider_<any>): void;
        get entity(): Internal.Entity
    }
    type ClientInitEventJS_ = ClientInitEventJS;
    class RelativeMovement extends Internal.Enum<Internal.RelativeMovement> {
        static valueOf($$0: string): Internal.RelativeMovement;
        static pack($$0: Internal.Set_<Internal.RelativeMovement>): number;
        static values(): Internal.RelativeMovement[];
        static unpack($$0: number): Internal.Set<Internal.RelativeMovement>;
        static readonly Y_ROT: Internal.RelativeMovement;
        static readonly ALL: Internal.Set<Internal.RelativeMovement>;
        static readonly X: Internal.RelativeMovement;
        static readonly Y: Internal.RelativeMovement;
        static readonly Z: Internal.RelativeMovement;
        static readonly X_ROT: Internal.RelativeMovement;
        static readonly ROTATION: Internal.Set<Internal.RelativeMovement>;
    }
    type RelativeMovement_ = RelativeMovement | "z" | "y" | "x" | "y_rot" | "x_rot";
    class ItemDeathwormGauntlet extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemDeathwormGauntlet_ = ItemDeathwormGauntlet;
    class ModelCuboid {
        constructor(u: number, v: number, x1: number, y1: number, z1: number, sizeX: number, sizeY: number, sizeZ: number, extraX: number, extraY: number, extraZ: number, mirror: boolean, textureWidth: number, textureHeight: number, renderDirections: Internal.Set_<Internal.Direction>)
        shouldDrawFace(faceIndex: number): boolean;
        static getFaceIndex(dir: Internal.Direction_): number;
        readonly mirror: boolean;
        static readonly FACE_NEG_Z: 3;
        static readonly FACE_NEG_Y: 0;
        static readonly FACE_NEG_X: 2;
        readonly u4: number;
        readonly u5: number;
        readonly u2: number;
        readonly u3: number;
        readonly u0: number;
        readonly v1: number;
        readonly u1: number;
        readonly v2: number;
        readonly x1: number;
        readonly y2: number;
        readonly x2: number;
        readonly v0: number;
        readonly z1: number;
        readonly y1: number;
        readonly z2: number;
        static readonly FACE_POS_X: 4;
        static readonly FACE_POS_Z: 5;
        static readonly FACE_POS_Y: 1;
    }
    type ModelCuboid_ = ModelCuboid;
    class ClientboundRecipePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.ClientboundRecipePacket$State_, $$1: Internal.Collection_<ResourceLocation>, $$2: Internal.Collection_<ResourceLocation>, $$3: Internal.RecipeBookSettings_)
        constructor($$0: Internal.FriendlyByteBuf_)
        getRecipes(): Internal.List<ResourceLocation>;
        handle(arg0: Internal.PacketListener_): void;
        getHighlights(): Internal.List<ResourceLocation>;
        write($$0: Internal.FriendlyByteBuf_): void;
        getState(): Internal.ClientboundRecipePacket$State;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getBookSettings(): Internal.RecipeBookSettings;
        isSkippable(): boolean;
        get recipes(): Internal.List<ResourceLocation>
        get highlights(): Internal.List<ResourceLocation>
        get state(): Internal.ClientboundRecipePacket$State
        get bookSettings(): Internal.RecipeBookSettings
        get skippable(): boolean
    }
    type ClientboundRecipePacket_ = ClientboundRecipePacket;
    class RunningShoesItem extends Internal.WearableArtifactItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        hasNonCosmeticEffects(): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type RunningShoesItem_ = RunningShoesItem;
    class Agent {
        constructor(arg0: string, arg1: number)
        getName(): string;
        getVersion(): number;
        get name(): string
        get version(): number
        static readonly SCROLLS: Internal.Agent;
        static readonly MINECRAFT: Internal.Agent;
    }
    type Agent_ = Agent;
    class SpectralArrowItem extends Internal.ArrowItem {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SpectralArrowItem_ = SpectralArrowItem;
    interface ServerGamePacketListener extends Internal.ServerPacketListener {
        abstract handleChatCommand(arg0: Internal.ServerboundChatCommandPacket_): void;
        abstract handlePlayerAbilities(arg0: Internal.ServerboundPlayerAbilitiesPacket_): void;
        abstract handlePlayerInput(arg0: Internal.ServerboundPlayerInputPacket_): void;
        abstract handleClientCommand(arg0: Internal.ServerboundClientCommandPacket_): void;
        abstract handleResourcePackResponse(arg0: Internal.ServerboundResourcePackPacket_): void;
        abstract handleSetCarriedItem(arg0: Internal.ServerboundSetCarriedItemPacket_): void;
        abstract handlePickItem(arg0: Internal.ServerboundPickItemPacket_): void;
        abstract handleSetCreativeModeSlot(arg0: Internal.ServerboundSetCreativeModeSlotPacket_): void;
        abstract handleSeenAdvancements(arg0: Internal.ServerboundSeenAdvancementsPacket_): void;
        abstract handleKeepAlive(arg0: Internal.ServerboundKeepAlivePacket_): void;
        abstract handleUseItem(arg0: Internal.ServerboundUseItemPacket_): void;
        abstract handlePaddleBoat(arg0: Internal.ServerboundPaddleBoatPacket_): void;
        abstract handleSetStructureBlock(arg0: Internal.ServerboundSetStructureBlockPacket_): void;
        abstract handleCustomPayload(arg0: Internal.ServerboundCustomPayloadPacket_): void;
        abstract handleSelectTrade(arg0: Internal.ServerboundSelectTradePacket_): void;
        abstract handleJigsawGenerate(arg0: Internal.ServerboundJigsawGeneratePacket_): void;
        abstract onDisconnect(arg0: net.minecraft.network.chat.Component_): void;
        abstract handleSetJigsawBlock(arg0: Internal.ServerboundSetJigsawBlockPacket_): void;
        abstract handleSetCommandMinecart(arg0: Internal.ServerboundSetCommandMinecartPacket_): void;
        abstract handleSetCommandBlock(arg0: Internal.ServerboundSetCommandBlockPacket_): void;
        abstract handleRecipeBookSeenRecipePacket(arg0: Internal.ServerboundRecipeBookSeenRecipePacket_): void;
        abstract handleBlockEntityTagQuery(arg0: Internal.ServerboundBlockEntityTagQuery_): void;
        abstract handleChatSessionUpdate(arg0: Internal.ServerboundChatSessionUpdatePacket_): void;
        abstract handleContainerButtonClick(arg0: Internal.ServerboundContainerButtonClickPacket_): void;
        abstract handlePong(arg0: Internal.ServerboundPongPacket_): void;
        abstract handlePlaceRecipe(arg0: Internal.ServerboundPlaceRecipePacket_): void;
        abstract handlePlayerCommand(arg0: Internal.ServerboundPlayerCommandPacket_): void;
        abstract handleEditBook(arg0: Internal.ServerboundEditBookPacket_): void;
        abstract handleTeleportToEntityPacket(arg0: Internal.ServerboundTeleportToEntityPacket_): void;
        abstract handleInteract(arg0: Internal.ServerboundInteractPacket_): void;
        abstract handleContainerClose(arg0: Internal.ServerboundContainerClosePacket_): void;
        abstract handleChangeDifficulty(arg0: Internal.ServerboundChangeDifficultyPacket_): void;
        abstract handleClientInformation(arg0: Internal.ServerboundClientInformationPacket_): void;
        abstract handleRecipeBookChangeSettingsPacket(arg0: Internal.ServerboundRecipeBookChangeSettingsPacket_): void;
        abstract isAcceptingMessages(): boolean;
        abstract handleContainerClick(arg0: Internal.ServerboundContainerClickPacket_): void;
        abstract handleCustomCommandSuggestions(arg0: Internal.ServerboundCommandSuggestionPacket_): void;
        abstract handleAcceptTeleportPacket(arg0: Internal.ServerboundAcceptTeleportationPacket_): void;
        abstract handleMovePlayer(arg0: Internal.ServerboundMovePlayerPacket_): void;
        abstract handleChatAck(arg0: Internal.ServerboundChatAckPacket_): void;
        abstract handlePlayerAction(arg0: Internal.ServerboundPlayerActionPacket_): void;
        abstract handleLockDifficulty(arg0: Internal.ServerboundLockDifficultyPacket_): void;
        abstract handleAnimate(arg0: Internal.ServerboundSwingPacket_): void;
        abstract handleRenameItem(arg0: Internal.ServerboundRenameItemPacket_): void;
        shouldPropagateHandlingExceptions(): boolean;
        abstract handleEntityTagQuery(arg0: Internal.ServerboundEntityTagQuery_): void;
        abstract handleSignUpdate(arg0: Internal.ServerboundSignUpdatePacket_): void;
        abstract handleChat(arg0: Internal.ServerboundChatPacket_): void;
        abstract handleSetBeaconPacket(arg0: Internal.ServerboundSetBeaconPacket_): void;
        abstract handleUseItemOn(arg0: Internal.ServerboundUseItemOnPacket_): void;
        abstract handleMoveVehicle(arg0: Internal.ServerboundMoveVehiclePacket_): void;
        get acceptingMessages(): boolean
    }
    type ServerGamePacketListener_ = ServerGamePacketListener;
    interface FluidData {
        getOptionalBucket(): Internal.Optional<Internal.Item>;
        abstract getBlock(): Internal.Supplier<Internal.LiquidBlock>;
        abstract setStillFluid(arg0: Internal.Supplier_<Internal.FlowingFluid>): void;
        abstract getBucket(): Internal.Supplier<Internal.Item>;
        abstract setBucket(arg0: Internal.Supplier_<Internal.Item>): void;
        abstract getInformation(): Internal.FluidInformation;
        getOptionalFlowingFluid(): Internal.Optional<Internal.FlowingFluid>;
        getOptionalStillFluid(): Internal.Optional<Internal.FlowingFluid>;
        abstract getStillFluid(): Internal.Supplier<Internal.FlowingFluid>;
        getOptionalBlock(): Internal.Optional<Internal.LiquidBlock>;
        /**
         * @deprecated
        */
        abstract getProperties(): Internal.FluidProperties;
        abstract setBlock(arg0: Internal.Supplier_<Internal.LiquidBlock>): void;
        abstract getFlowingFluid(): Internal.Supplier<Internal.FlowingFluid>;
        abstract setFlowingFluid(arg0: Internal.Supplier_<Internal.FlowingFluid>): void;
        get optionalBucket(): Internal.Optional<Internal.Item>
        get block(): Internal.Supplier<Internal.LiquidBlock>
        set stillFluid(arg0: Internal.Supplier_<Internal.FlowingFluid>)
        get bucket(): Internal.Supplier<Internal.Item>
        set bucket(arg0: Internal.Supplier_<Internal.Item>)
        get information(): Internal.FluidInformation
        get optionalFlowingFluid(): Internal.Optional<Internal.FlowingFluid>
        get optionalStillFluid(): Internal.Optional<Internal.FlowingFluid>
        get stillFluid(): Internal.Supplier<Internal.FlowingFluid>
        get optionalBlock(): Internal.Optional<Internal.LiquidBlock>
        /**
         * @deprecated
        */
        get properties(): Internal.FluidProperties
        set block(arg0: Internal.Supplier_<Internal.LiquidBlock>)
        get flowingFluid(): Internal.Supplier<Internal.FlowingFluid>
        set flowingFluid(arg0: Internal.Supplier_<Internal.FlowingFluid>)
    }
    type FluidData_ = FluidData;
    class FeaturePlaceContext <FC extends Internal.FeatureConfiguration> {
        constructor($$0: Internal.Optional_<Internal.ConfiguredFeature<any, any>>, $$1: Internal.WorldGenLevel_, $$2: Internal.ChunkGenerator_, $$3: Internal.RandomSource_, $$4: BlockPos_, $$5: FC)
        config(): FC;
        topFeature(): Internal.Optional<Internal.ConfiguredFeature<any, any>>;
        origin(): BlockPos;
        random(): Internal.RandomSource;
        level(): Internal.WorldGenLevel;
        chunkGenerator(): Internal.ChunkGenerator;
    }
    type FeaturePlaceContext_<FC extends Internal.FeatureConfiguration> = FeaturePlaceContext<FC>;
    interface Stitcher$Entry {
        abstract width(): number;
        abstract height(): number;
        abstract name(): ResourceLocation;
    }
    type Stitcher$Entry_ = Stitcher$Entry;
    class IpBanList extends Internal.StoredUserList<string, Internal.IpBanListEntry> {
        constructor($$0: Internal.File_)
        isBanned($$0: string): boolean;
        isBanned($$0: Internal.SocketAddress_): boolean;
        get($$0: Internal.SocketAddress_): Internal.IpBanListEntry;
    }
    type IpBanList_ = IpBanList;
    class RainforestCliffsVinesFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        static isAir(level: Internal.LevelSimulatedReader_, pos: BlockPos_): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type RainforestCliffsVinesFeature_ = RainforestCliffsVinesFeature;
    interface IWaypointableNavigation {
        abstract railways$isWaypointMode(): boolean;
        (): boolean;
    }
    type IWaypointableNavigation_ = IWaypointableNavigation;
    interface SimpleWaterloggedBlock extends Internal.BucketPickup, Internal.LiquidBlockContainer {
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
    }
    type SimpleWaterloggedBlock_ = SimpleWaterloggedBlock;
    class BlockSlate extends Internal.BlockCircleComponent implements Internal.SimpleWaterloggedBlock, Internal.EntityBlock {
        constructor(p_53182_: Internal.BlockBehaviour$Properties_)
        newBlockEntity(pPos: BlockPos_, pState: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        static sfx(pos: BlockPos_, bs: Internal.BlockState_, world: Internal.Level_, impetus: Internal.BlockEntityAbstractImpetus_, success: boolean): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        fakeThrowMishap(pos: BlockPos_, bs: Internal.BlockState_, image: Internal.CastingImage_, env: Internal.CircleCastEnv_, mishap: Internal.Mishap_): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static canAttach(pReader: Internal.LevelReader_, pPos: BlockPos_, pDirection: Internal.Direction_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getCloneItemStack(state: Internal.BlockState_, target: Internal.HitResult_, level: Internal.BlockGetter_, pos: BlockPos_, player: Internal.Player_): Internal.ItemStack;
        exitPositionFromDirection(pos: BlockPos_, dir: Internal.Direction_): com.mojang.datafixers.util.Pair<BlockPos, Internal.Direction>;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly THICKNESS: 1.0;
        static readonly AABB_NORTH_WALL: Internal.VoxelShapeSimpleCube;
        static readonly AABB_CEILING: Internal.VoxelShapeSimpleCube;
        static readonly ATTACH_FACE: Internal.EnumProperty<Internal.AttachFace>;
        static readonly AABB_EAST_WALL: Internal.VoxelShapeSimpleCube;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly AABB_WEST_WALL: Internal.VoxelShapeSimpleCube;
        static readonly AABB_SOUTH_WALL: Internal.VoxelShapeSimpleCube;
        static readonly AABB_FLOOR: Internal.VoxelShapeSimpleCube;
        static readonly FACING: Internal.DirectionProperty;
    }
    type BlockSlate_ = BlockSlate;
    class PotionBucketItem extends Internal.PotionItem {
        constructor(supplier: Internal.Supplier_<Internal.Fluid>, builder: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getFluid(): Internal.Fluid;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get fluid(): Internal.Fluid
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type PotionBucketItem_ = PotionBucketItem;
    interface ChannelPipeline extends Internal.Iterable<Internal.Map$Entry<string, Internal.ChannelHandler>>, Internal.ChannelOutboundInvoker, Internal.ChannelInboundInvoker {
        abstract fireExceptionCaught(arg0: Internal.Throwable_): this;
        abstract firstContext(): Internal.ChannelHandlerContext;
        abstract addBefore(arg0: Internal.EventExecutorGroup_, arg1: string, arg2: string, arg3: Internal.ChannelHandler_): this;
        abstract addFirst(arg0: Internal.EventExecutorGroup_, ...arg1: Internal.ChannelHandler_[]): this;
        abstract addAfter(arg0: string, arg1: string, arg2: Internal.ChannelHandler_): this;
        abstract remove<T extends Internal.ChannelHandler>(arg0: T): T;
        abstract removeFirst(): Internal.ChannelHandler;
        abstract write(arg0: any): Internal.ChannelFuture;
        abstract replace<T extends Internal.ChannelHandler>(arg0: T, arg1: string, arg2: Internal.ChannelHandler_): T;
        abstract fireChannelWritabilityChanged(): this;
        abstract close(): Internal.ChannelFuture;
        abstract write(arg0: any, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract toMap(): Internal.Map<string, Internal.ChannelHandler>;
        abstract addFirst(arg0: string, arg1: Internal.ChannelHandler_): this;
        spliterator(): Internal.Spliterator<Internal.Map$Entry<string, Internal.ChannelHandler>>;
        abstract replace(arg0: string, arg1: string, arg2: Internal.ChannelHandler_): Internal.ChannelHandler;
        abstract first(): Internal.ChannelHandler;
        abstract addBefore(arg0: string, arg1: string, arg2: Internal.ChannelHandler_): this;
        abstract bind(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract remove(arg0: Internal.ChannelHandler_): this;
        forEach(arg0: Internal.Consumer_<Internal.Map$Entry<string, Internal.ChannelHandler>>): void;
        abstract get(arg0: string): Internal.ChannelHandler;
        abstract addLast(arg0: Internal.EventExecutorGroup_, arg1: string, arg2: Internal.ChannelHandler_): this;
        abstract lastContext(): Internal.ChannelHandlerContext;
        abstract read(): Internal.ChannelOutboundInvoker;
        abstract fireChannelUnregistered(): this;
        abstract voidPromise(): Internal.ChannelPromise;
        abstract context(arg0: Internal.ChannelHandler_): Internal.ChannelHandlerContext;
        abstract addLast(...arg0: Internal.ChannelHandler_[]): this;
        abstract fireChannelInactive(): this;
        abstract addFirst(arg0: Internal.EventExecutorGroup_, arg1: string, arg2: Internal.ChannelHandler_): this;
        abstract connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_, arg2: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract deregister(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract fireChannelRegistered(): this;
        abstract replace(arg0: Internal.ChannelHandler_, arg1: string, arg2: Internal.ChannelHandler_): this;
        abstract writeAndFlush(arg0: any): Internal.ChannelFuture;
        abstract disconnect(): Internal.ChannelFuture;
        abstract context(arg0: string): Internal.ChannelHandlerContext;
        abstract fireChannelRead(arg0: any): this;
        abstract fireUserEventTriggered(arg0: any): this;
        abstract addAfter(arg0: Internal.EventExecutorGroup_, arg1: string, arg2: string, arg3: Internal.ChannelHandler_): this;
        abstract connect(arg0: Internal.SocketAddress_): Internal.ChannelFuture;
        abstract connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_): Internal.ChannelFuture;
        abstract names(): Internal.List<string>;
        abstract deregister(): Internal.ChannelFuture;
        abstract disconnect(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract addLast(arg0: Internal.EventExecutorGroup_, ...arg1: Internal.ChannelHandler_[]): this;
        abstract newFailedFuture(arg0: Internal.Throwable_): Internal.ChannelFuture;
        abstract fireChannelReadComplete(): this;
        abstract close(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract newSucceededFuture(): Internal.ChannelFuture;
        abstract newProgressivePromise(): Internal.ChannelProgressivePromise;
        abstract iterator(): Internal.Iterator<Internal.Map$Entry<string, Internal.ChannelHandler>>;
        abstract fireChannelActive(): this;
        abstract last(): Internal.ChannelHandler;
        abstract get<T extends Internal.ChannelHandler>(arg0: T): T;
        abstract channel(): io.netty.channel.Channel;
        abstract remove(arg0: string): Internal.ChannelHandler;
        abstract writeAndFlush(arg0: any, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract bind(arg0: Internal.SocketAddress_): Internal.ChannelFuture;
        abstract context(arg0: typeof Internal.ChannelHandler): Internal.ChannelHandlerContext;
        abstract connect(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract addFirst(...arg0: Internal.ChannelHandler_[]): this;
        abstract flush(): this;
        abstract removeLast(): Internal.ChannelHandler;
        abstract addLast(arg0: string, arg1: Internal.ChannelHandler_): this;
        abstract newPromise(): Internal.ChannelPromise;
    }
    type ChannelPipeline_ = ChannelPipeline;
    class DragonFlameParticleType extends Internal.DragonParticleType<Internal.DragonFlameParticleType> {
        constructor()
        constructor(scale: number)
        codec(): Internal.Codec<Internal.DragonFlameParticleType>;
    }
    type DragonFlameParticleType_ = DragonFlameParticleType;
    interface ObjectCollection <K> extends Internal.Collection<K>, Internal.ObjectIterable<K> {
        abstract addAll(arg0: Internal.Collection_<K>): boolean;
        iterator(): Internal.Iterator<any>;
        abstract toArray<T>(arg0: T[]): T[];
        forEach(arg0: Internal.Consumer_<K>): void;
        spliterator(): Internal.ObjectSpliterator<K>;
        abstract remove(arg0: any): boolean;
        abstract isEmpty(): boolean;
        abstract toArray(): any[];
        removeIf(arg0: Internal.Predicate_<K>): boolean;
        parallelStream(): Internal.Stream<K>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract size(): number;
        abstract hashCode(): number;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        abstract clear(): void;
        abstract equals(arg0: any): boolean;
        abstract add(arg0: K): boolean;
        stream(): Internal.Stream<K>;
        abstract contains(arg0: any): boolean;
        get empty(): boolean
    }
    type ObjectCollection_<K> = ObjectCollection<K>;
    interface IExtendedBiomeSource {
        abstract appendDeferredBiomesList(arg0: Internal.List_<Internal.Holder<Internal.Biome>>): void;
        (arg0: Internal.List<Internal.Holder<Internal.Biome>>): void;
    }
    type IExtendedBiomeSource_ = IExtendedBiomeSource;
    class NbtAccounter implements Internal.NbtAccounterAccessor {
        constructor($$0: number)
        accountBytes($$0: number): void;
        create$getUsage(): number;
        getUsage(): number;
        get usage(): number
        static readonly UNLIMITED: Internal.NbtAccounter;
    }
    type NbtAccounter_ = NbtAccounter;
    interface CustomLandingEffectsBlock {
        abstract addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        (arg0: Internal.BlockState, arg1: Internal.ServerLevel, arg2: BlockPos, arg3: Internal.BlockState, arg4: Internal.LivingEntity, arg5: number): boolean;
    }
    type CustomLandingEffectsBlock_ = CustomLandingEffectsBlock;
    class SmithingTablePatternItem extends Internal.EncodedPatternItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        encode(recipe: Internal.SmithingRecipe_, template: Internal.AEItemKey_, base: Internal.AEItemKey_, addition: Internal.AEItemKey_, out: Internal.AEItemKey_, allowSubstitutes: boolean): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SmithingTablePatternItem_ = SmithingTablePatternItem;
    class KelpPlantBlock extends Internal.GrowingPlantBodyBlock implements Internal.LiquidBlockContainer {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type KelpPlantBlock_ = KelpPlantBlock;
    class VariantBlockStateGenerator$Model {
        constructor()
        uvlock(): this;
        x(_x: number): this;
        y(_y: number): this;
        model(s: string): this;
        toJson(): Internal.JsonObject;
    }
    type VariantBlockStateGenerator$Model_ = VariantBlockStateGenerator$Model;
    class LazyMaterial implements Internal.Supplier<Internal.IMaterial> {
        static of(material: Internal.IMaterial_): Internal.LazyMaterial;
        getId(): Internal.MaterialId;
        isUnknown(): boolean;
        static of(id: Internal.MaterialId_): Internal.LazyMaterial;
        matches(material: Internal.MaterialId_): boolean;
        get(): Internal.IMaterial;
        get id(): Internal.MaterialId
        get unknown(): boolean
    }
    type LazyMaterial_ = LazyMaterial;
    class BlockPlaceContext extends Internal.UseOnContext {
        constructor($$0: Internal.Player_, $$1: Internal.InteractionHand_, $$2: Internal.ItemStack_, $$3: Internal.BlockHitResult_)
        constructor($$0: Internal.Level_, $$1: Internal.Player_, $$2: Internal.InteractionHand_, $$3: Internal.ItemStack_, $$4: Internal.BlockHitResult_)
        constructor($$0: Internal.UseOnContext_)
        getNearestLookingDirection(): Internal.Direction;
        static createUseOnContext(level: Internal.Level_, player: Internal.Player_, interactionHand: Internal.InteractionHand_, itemStack: Internal.ItemStack_, blockHitResult: Internal.BlockHitResult_): Internal.UseOnContext;
        getNearestLookingVerticalDirection(): Internal.Direction;
        getNearestLookingDirections(): Internal.Direction[];
        replacingClickedOnBlock(): boolean;
        static hex$new($$0: Internal.Level_, $$1: Internal.Player_, $$2: Internal.InteractionHand_, $$3: Internal.ItemStack_, $$4: Internal.BlockHitResult_): Internal.UseOnContext;
        static at($$0: Internal.BlockPlaceContext_, $$1: BlockPos_, $$2: Internal.Direction_): Internal.BlockPlaceContext;
        canPlace(): boolean;
        handler$feg000$moonlight$fixNotAccountingForNullPlayer3(cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$feg000$moonlight$fixNotAccountingForNullPlayer2(cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$feg000$moonlight$fixNotAccountingForNullPlayer1(cir: Internal.CallbackInfoReturnable_<any>): void;
        get nearestLookingDirection(): Internal.Direction
        get nearestLookingVerticalDirection(): Internal.Direction
        get nearestLookingDirections(): Internal.Direction[]
        replaceClicked: boolean;
    }
    type BlockPlaceContext_ = BlockPlaceContext;
    interface Object2ShortFunction <K> extends it.unimi.dsi.fastutil.Function<K, number>, Internal.ToIntFunction<K> {
        andThenObject<T>(arg0: Internal.Short2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        andThenFloat(arg0: Internal.Short2FloatFunction_): Internal.Object2FloatFunction<K>;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2ShortFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        remove(arg0: any): number;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2ShortFunction<T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2ShortFunction;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2ShortFunction;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2ShortFunction;
        andThenInt(arg0: Internal.Short2IntFunction_): Internal.Object2IntFunction<K>;
        containsKey(arg0: any): boolean;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        andThenLong(arg0: Internal.Short2LongFunction_): Internal.Object2LongFunction<K>;
        defaultReturnValue(): number;
        andThenShort(arg0: Internal.Short2ShortFunction_): this;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2ShortFunction;
        getOrDefault(arg0: any, arg1: number): number;
        andThenReference<T>(arg0: Internal.Short2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        apply(arg0: K): number;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        abstract getShort(arg0: any): number;
        andThenDouble(arg0: Internal.Short2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        removeShort(arg0: any): number;
        put(arg0: K, arg1: number): number;
        andThenChar(arg0: Internal.Short2CharFunction_): Internal.Object2CharFunction<K>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2ShortFunction<T>;
        applyAsInt(arg0: K): number;
        andThenByte(arg0: Internal.Short2ByteFunction_): Internal.Object2ByteFunction<K>;
        size(): number;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2ShortFunction;
        defaultReturnValue(arg0: number): void;
        clear(): void;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2ShortFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        identity<T>(): Internal.Function<T, T>;
        (arg0: any): number;
    }
    type Object2ShortFunction_<K> = Object2ShortFunction<K>;
    interface IProxyHoveringInformation {
        abstract getInformationSource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_): BlockPos;
        (arg0: Internal.Level, arg1: BlockPos, arg2: Internal.BlockState): BlockPos_;
    }
    type IProxyHoveringInformation_ = IProxyHoveringInformation;
    class LargeWaterWheelBlockEntity extends Internal.WaterWheelBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
    }
    type LargeWaterWheelBlockEntity_ = LargeWaterWheelBlockEntity;
    class BayouTreeFeature extends Internal.BOPTreeFeature<Internal.BayouTreeConfiguration> {
        constructor(codec: Internal.Codec_<Internal.BayouTreeConfiguration>)
        generateLeafLayer(world: Internal.LevelAccessor_, rand: Internal.RandomSource_, pos: BlockPos_, leavesRadius: number, leaves: Internal.FoliagePlacer$FoliageSetter_, config: Internal.BayouTreeConfiguration_): void;
        placeLeaves(level: Internal.LevelAccessor_, pos: BlockPos_, leaves: Internal.FoliagePlacer$FoliageSetter_, config: Internal.BayouTreeConfiguration_): boolean;
        static placeSpanishMossColumn(p_236427_0_: Internal.LevelAccessor_, p_236427_1_: Internal.RandomSource_, p_236427_2_: Internal.BlockPos$MutableBlockPos_, p_236427_3_: number, p_236427_4_: number, p_236427_5_: number): void;
        generateBranch(world: Internal.LevelAccessor_, rand: Internal.RandomSource_, pos: BlockPos_, direction: Internal.Direction_, length: number, logs: Internal.BiConsumer_<BlockPos, Internal.BlockState>, leaves: Internal.FoliagePlacer$FoliageSetter_, config: Internal.BayouTreeConfiguration_): void;
        checkSpace(world: Internal.LevelAccessor_, pos: BlockPos_, baseHeight: number, height: number, config: Internal.BayouTreeConfiguration_): boolean;
    }
    type BayouTreeFeature_ = BayouTreeFeature;
    class ModifiableCrossbowItem extends Internal.ModifiableLauncherItem {
        constructor(properties: Internal.Item$Properties_, toolDefinition: Internal.ToolDefinition_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static getDisplayStack(item: Internal.Item_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLocalizedName(): net.minecraft.network.chat.Component;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getStatInformation(tool: Internal.IToolStackView_, player: Internal.Player_, tooltips: Internal.List_<net.minecraft.network.chat.Component>, key: Internal.TooltipKey_, tooltipFlag: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        setAttackSpeed(attackSpeed: number): void;
        static fireCrossbow(tool: Internal.IToolStackView_, player: Internal.Player_, hand: Internal.InteractionHand_, heldAmmo: Internal.CompoundTag_): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static setRarity(volatileData: Internal.ModDataNBT_, rarity: Internal.Rarity_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get localizedName(): net.minecraft.network.chat.Component
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly KEY_CROSSBOW_AMMO: ResourceLocation;
    }
    type ModifiableCrossbowItem_ = ModifiableCrossbowItem;
    interface ConfigSpec$CorrectionListener {
        abstract onCorrect(arg0: Internal.ConfigSpec$CorrectionAction_, arg1: Internal.List_<string>, arg2: any, arg3: any): void;
        (arg0: Internal.ConfigSpec$CorrectionAction, arg1: Internal.List<string>, arg2: any, arg3: any): void;
    }
    type ConfigSpec$CorrectionListener_ = ConfigSpec$CorrectionListener;
    class PlateArmorItem extends Internal.ModifiableArmorItem {
        constructor(material: any_, slotType: any_, properties: Internal.Item$Properties_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static getDisplayStack(item: Internal.Item_): Internal.ItemStack;
        initializeClient(): void;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLocalizedName(): net.minecraft.network.chat.Component;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        doVanillaElytraTick(entity: Internal.LivingEntity_, chestStack: Internal.ItemStack_): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static setRarity(volatileData: Internal.ModDataNBT_, rarity: Internal.Rarity_): void;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get localizedName(): net.minecraft.network.chat.Component
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type PlateArmorItem_ = PlateArmorItem;
    class ServerboundPlaceRecipePacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: Internal.Recipe_<any>, $$2: boolean)
        handle(arg0: Internal.PacketListener_): void;
        getRecipe(): ResourceLocation;
        write($$0: Internal.FriendlyByteBuf_): void;
        isShiftDown(): boolean;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getContainerId(): number;
        isSkippable(): boolean;
        get recipe(): ResourceLocation
        get shiftDown(): boolean
        get containerId(): number
        get skippable(): boolean
    }
    type ServerboundPlaceRecipePacket_ = ServerboundPlaceRecipePacket;
    abstract class SignatureSpi {
        constructor()
        clone(): any;
    }
    type SignatureSpi_ = SignatureSpi;
    class PiglinWallSkullBlock extends Internal.WallSkullBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
    }
    type PiglinWallSkullBlock_ = PiglinWallSkullBlock;
    class FormatStyle extends Internal.Enum<Internal.FormatStyle> {
        static values(): Internal.FormatStyle[];
        static valueOf(arg0: string): Internal.FormatStyle;
        static readonly SHORT: Internal.FormatStyle;
        static readonly FULL: Internal.FormatStyle;
        static readonly LONG: Internal.FormatStyle;
        static readonly MEDIUM: Internal.FormatStyle;
    }
    type FormatStyle_ = "medium" | "short" | "full" | FormatStyle | "long";
    class ReflectionAccessFilter$FilterResult extends Internal.Enum<Internal.ReflectionAccessFilter$FilterResult> {
        static values(): Internal.ReflectionAccessFilter$FilterResult[];
        static valueOf(arg0: string): Internal.ReflectionAccessFilter$FilterResult;
        static readonly ALLOW: Internal.ReflectionAccessFilter$FilterResult;
        static readonly BLOCK_INACCESSIBLE: Internal.ReflectionAccessFilter$FilterResult;
        static readonly INDECISIVE: Internal.ReflectionAccessFilter$FilterResult;
        static readonly BLOCK_ALL: Internal.ReflectionAccessFilter$FilterResult;
    }
    type ReflectionAccessFilter$FilterResult_ = ReflectionAccessFilter$FilterResult | "block_all" | "allow" | "block_inaccessible" | "indecisive";
    class TrackMaterial$TrackType {
        constructor(id: ResourceLocation_, factory: any_)
        static readonly STANDARD: Internal.TrackMaterial$TrackType;
        readonly id: ResourceLocation;
    }
    type TrackMaterial$TrackType_ = TrackMaterial$TrackType;
    abstract class SupportType extends Internal.Enum<Internal.SupportType> {
        static values(): Internal.SupportType[];
        static valueOf($$0: string): Internal.SupportType;
        abstract isSupporting(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        static readonly CENTER: Internal.SupportType;
        static readonly RIGID: Internal.SupportType;
        static readonly FULL: Internal.SupportType;
    }
    type SupportType_ = "center" | SupportType | "full" | "rigid";
    class GameNarrator {
        constructor($$0: Internal.Minecraft_)
        sayChat($$0: net.minecraft.network.chat.Component_): void;
        say($$0: net.minecraft.network.chat.Component_): void;
        sayNow($$0: string): void;
        checkStatus($$0: boolean): void;
        clear(): void;
        updateNarratorStatus($$0: Internal.NarratorStatus_): void;
        destroy(): void;
        sayNow($$0: net.minecraft.network.chat.Component_): void;
        isActive(): boolean;
        get active(): boolean
        static readonly NO_TITLE: Internal.MutableComponent;
    }
    type GameNarrator_ = GameNarrator;
    class ICustomParticleDataWithSprite$1 extends Internal.ParticleType<T> {
        codec(): Internal.Codec<T>;
    }
    type ICustomParticleDataWithSprite$1_ = ICustomParticleDataWithSprite$1;
    class DragonForgePropertyDelegate implements Internal.ContainerData {
        constructor()
        getCount(): number;
        get(index: number): number;
        set(index: number, value: number): void;
        get count(): number
        fireType: number;
        cookTime: number;
    }
    type DragonForgePropertyDelegate_ = DragonForgePropertyDelegate;
    class ImmutableSetMultimap$Builder <K, V> extends Internal.ImmutableMultimap$Builder<K, V> {
        constructor()
        put(arg0: Internal.Map$Entry_<K, V>): this;
        put(arg0: any, arg1: any): Internal.ImmutableMultimap$Builder<any, any>;
        build(): Internal.ImmutableMultimap<any, any>;
        putAll(arg0: Internal.Iterable_<any>): Internal.ImmutableMultimap$Builder<any, any>;
        orderValuesBy(arg0: Internal.Comparator_<any>): Internal.ImmutableMultimap$Builder<any, any>;
        putAll(arg0: any, arg1: Internal.Iterable_<any>): Internal.ImmutableMultimap$Builder<any, any>;
        putAll(arg0: Internal.Multimap_<any, any>): Internal.ImmutableMultimap$Builder<any, any>;
        orderKeysBy(arg0: Internal.Comparator_<K>): this;
        putAll(arg0: any, arg1: any[]): Internal.ImmutableMultimap$Builder<any, any>;
    }
    type ImmutableSetMultimap$Builder_<K, V> = ImmutableSetMultimap$Builder<K, V>;
    interface DispenserBlockAccessor {
        getDispenserRegistry(): Internal.Map<Internal.Item, Internal.DispenseItemBehavior>;
        get dispenserRegistry(): Internal.Map<Internal.Item, Internal.DispenseItemBehavior>
    }
    type DispenserBlockAccessor_ = DispenserBlockAccessor;
    class WorldSectionBox extends Internal.Record {
        constructor(world: Internal.Level_, chunkX1: number, chunkY1: number, chunkZ1: number, chunkX2: number, chunkY2: number, chunkZ2: number)
        world(): Internal.Level;
        numSections(): number;
        static entityAccessBox(world: Internal.Level_, box: Internal.AABB_): Internal.WorldSectionBox;
        matchesRelevantBlocksBox(box: Internal.AABB_): boolean;
        static relevantFluidBox(world: Internal.Level_, box: Internal.AABB_): Internal.WorldSectionBox;
        chunkY2(): number;
        chunkZ1(): number;
        chunkX2(): number;
        static relevantExpandedBlocksBox(world: Internal.Level_, box: Internal.AABB_): Internal.WorldSectionBox;
        chunkX1(): number;
        chunkZ2(): number;
        chunkY1(): number;
    }
    type WorldSectionBox_ = WorldSectionBox;
    interface DoubleStream$Builder extends Internal.DoubleConsumer {
        add(arg0: number): this;
        abstract accept(arg0: number): void;
        andThen(arg0: Internal.DoubleConsumer_): Internal.DoubleConsumer;
        abstract build(): Internal.DoubleStream;
    }
    type DoubleStream$Builder_ = DoubleStream$Builder;
    interface IPartItem <P extends Internal.IPart> extends Internal.ItemLike {
        abstract getPartClass(): P;
        getId(item: Internal.IPartItem_<any>): ResourceLocation;
        byId(id: ResourceLocation_): Internal.IPartItem<any>;
        emi(amount: number): Internal.EmiStack;
        abstract asItem(): Internal.Item;
        getNetworkId(item: Internal.IPartItem_<any>): number;
        emi(): Internal.EmiStack;
        abstract createPart(): P;
        byNetworkId(id: number): Internal.IPartItem<any>;
        get partClass(): P
    }
    type IPartItem_<P extends Internal.IPart> = IPartItem<P>;
    class AllFanProcessingTypes$BlastingType implements Internal.FanProcessingType {
        constructor()
        canProcess(stack: Internal.ItemStack_, level: Internal.Level_): boolean;
        getPriority(): number;
        morphAirFlow(particleAccess: Internal.FanProcessingType$AirFlowParticleAccess_, random: Internal.RandomSource_): void;
        isValidAt(level: Internal.Level_, pos: BlockPos_): boolean;
        static getAt(level: Internal.Level_, pos: BlockPos_): Internal.FanProcessingType;
        process(stack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemStack>;
        static parse(str: string): Internal.FanProcessingType;
        affectEntity(entity: Internal.Entity_, level: Internal.Level_): void;
        spawnProcessingParticles(level: Internal.Level_, pos: Vec3d_): void;
        get priority(): number
    }
    type AllFanProcessingTypes$BlastingType_ = AllFanProcessingTypes$BlastingType;
    class FossilFeatureConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: Internal.List_<ResourceLocation>, $$1: Internal.List_<ResourceLocation>, $$2: Internal.Holder_<Internal.StructureProcessorList>, $$3: Internal.Holder_<Internal.StructureProcessorList>, $$4: number)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        readonly overlayStructures: Internal.List<ResourceLocation>;
        readonly fossilStructures: Internal.List<ResourceLocation>;
        readonly maxEmptyCornersAllowed: number;
        readonly fossilProcessors: Internal.Holder<Internal.StructureProcessorList>;
        readonly overlayProcessors: Internal.Holder<Internal.StructureProcessorList>;
        static readonly CODEC: Internal.Codec<Internal.FossilFeatureConfiguration>;
    }
    type FossilFeatureConfiguration_ = FossilFeatureConfiguration;
    interface PackRepositoryAccessor {
        abstract getSources(): Internal.Set<Internal.RepositorySource>;
        abstract setSources(arg0: Internal.Set_<Internal.RepositorySource>): void;
        get sources(): Internal.Set<Internal.RepositorySource>
        set sources(arg0: Internal.Set_<Internal.RepositorySource>)
    }
    type PackRepositoryAccessor_ = PackRepositoryAccessor;
    class RelativeSide extends Internal.Enum<Internal.RelativeSide> {
        getUnrotatedSide(): Internal.Direction;
        static values(): Internal.RelativeSide[];
        static fromUnrotatedSide(side: Internal.Direction_): Internal.RelativeSide;
        static valueOf(name: string): Internal.RelativeSide;
        get unrotatedSide(): Internal.Direction
        static readonly BACK: Internal.RelativeSide;
        static readonly LEFT: Internal.RelativeSide;
        static readonly BOTTOM: Internal.RelativeSide;
        static readonly FRONT: Internal.RelativeSide;
        static readonly TOP: Internal.RelativeSide;
        static readonly RIGHT: Internal.RelativeSide;
    }
    type RelativeSide_ = RelativeSide | "front" | "bottom" | "top" | "right" | "back" | "left";
    class CrystalHeartItem extends Internal.WearableArtifactItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CrystalHeartItem_ = CrystalHeartItem;
    class AtlasSpriteRegistryEventJS extends Internal.EventJS {
        constructor(registry: Internal.Consumer_<ResourceLocation>)
        register(id: ResourceLocation_): void;
    }
    type AtlasSpriteRegistryEventJS_ = AtlasSpriteRegistryEventJS;
    interface PlayerAnimations {
        abstract hexicalModAnimations(): Internal.ModifierLayer<Internal.IAnimation>;
        (): Internal.ModifierLayer_<Internal.IAnimation>;
    }
    type PlayerAnimations_ = PlayerAnimations;
    abstract class AmbientCreature extends Internal.Mob {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type AmbientCreature_ = AmbientCreature;
    class EndIslandFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type EndIslandFeature_ = EndIslandFeature;
    interface ObjectList <K> extends Internal.ObjectCollection<K>, Internal.List<K>, Internal.Comparable<Internal.List<K>> {
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        abstract addAll(arg0: Internal.Collection_<K>): boolean;
        setElements(arg0: number, arg1: K[]): void;
        removeLast(): K;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        abstract set(arg0: number, arg1: K): K;
        parallelStream(): Internal.Stream<K>;
        abstract addAll(arg0: number, arg1: Internal.Collection_<K>): boolean;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        of<K>(): this;
        abstract addElements(arg0: number, arg1: K[], arg2: number, arg3: number): void;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        setElements(arg0: K[]): void;
        reversed(): Internal.SequencedCollection<any>;
        getLast(): K;
        of<K>(...arg0: K[]): this;
        listIterator(): Internal.ListIterator<any>;
        abstract size(arg0: number): void;
        abstract remove(arg0: number): K;
        of<K>(arg0: K, arg1: K, arg2: K): this;
        abstract indexOf(arg0: any): number;
        abstract toArray<T>(arg0: T[]): T[];
        forEach(arg0: Internal.Consumer_<K>): void;
        abstract remove(arg0: any): boolean;
        removeIf(arg0: Internal.Predicate_<K>): boolean;
        spliterator(): Internal.Spliterator<any>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        abstract add(arg0: K): boolean;
        abstract lastIndexOf(arg0: any): number;
        setElements(arg0: number, arg1: K[], arg2: number, arg3: number): void;
        abstract removeElements(arg0: number, arg1: number): void;
        addLast(arg0: K): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        abstract isEmpty(): boolean;
        getFirst(): K;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        removeFirst(): K;
        abstract addElements(arg0: number, arg1: K[]): void;
        abstract listIterator(arg0: number): Internal.ObjectListIterator<K>;
        abstract subList(arg0: number, arg1: number): this;
        of<K>(arg0: K): this;
        abstract get(arg0: number): K;
        abstract contains(arg0: any): boolean;
        addAll(arg0: number, arg1: Internal.ObjectList_<K>): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        addFirst(arg0: K): void;
        iterator(): Internal.Iterator<any>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        abstract add(arg0: number, arg1: K): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        abstract toArray(): any[];
        replaceAll(arg0: Internal.UnaryOperator_<K>): void;
        of<K>(arg0: K, arg1: K): this;
        addAll(arg0: Internal.ObjectList_<K>): boolean;
        unstableSort(arg0: Internal.Comparator_<K>): void;
        abstract size(): number;
        abstract hashCode(): number;
        abstract compareTo(arg0: Internal.List_<K>): number;
        sort(arg0: Internal.Comparator_<K>): void;
        abstract clear(): void;
        abstract equals(arg0: any): boolean;
        stream(): Internal.Stream<K>;
        abstract getElements(arg0: number, arg1: any[], arg2: number, arg3: number): void;
        set elements(arg0: K[])
        get last(): K
        get empty(): boolean
        get first(): K
    }
    type ObjectList_<K> = ObjectList<K>;
    class MageBlockEntity extends Internal.HexBlockEntity {
        constructor(pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getRedstone(): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setLifespan(<set-?>: number): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        setProperties(<set-?>: Internal.Map_<string, boolean>): void;
        getProperties(): Internal.Map<string, boolean>;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        setRedstone(<set-?>: number): void;
        getLifespan(): number;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        setProperty(property: string, args: Internal.List_<Internal.Iota>): void;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get redstone(): number
        set lifespan(<set-?>: number)
        set properties(<set-?>: Internal.Map_<string, boolean>)
        get properties(): Internal.Map<string, boolean>
        set redstone(<set-?>: number)
        get lifespan(): number
    }
    type MageBlockEntity_ = MageBlockEntity;
    class ArmorDyeingRecipe implements Internal.IMultiRecipe<Internal.IDisplayModifierRecipe>, Internal.ITinkerStationRecipe {
        constructor(id: ResourceLocation_, toolRequirement: Internal.Ingredient_)
        getGroup(): string;
        getValidatedResult(inv: Internal.ITinkerStationContainer_, registryAccess: Internal.RegistryAccess_): Internal.ValidatedResult;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        /**
         * @deprecated
        */
        getRemainingItems(inv: Internal.ITinkerStationContainer_): Internal.NonNullList<Internal.ItemStack>;
        matches(inv: Internal.ITinkerStationContainer_, world: Internal.Level_): boolean;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        updateInputs(result: Internal.ItemStack_, inv: Internal.IMutableTinkerStationContainer_, isServer: boolean): void;
        getRecipes(): Internal.List<Internal.IDisplayModifierRecipe>;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        /**
         * @deprecated
        */
        getRemainingItems(arg0: net.minecraft.world.Container_): Internal.NonNullList<any>;
        shrinkToolSlotBy(): number;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        assemble(inv: Internal.ITinkerStationContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get recipes(): Internal.List<Internal.IDisplayModifierRecipe>
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type ArmorDyeingRecipe_ = ArmorDyeingRecipe;
    interface Executor {
        abstract execute(arg0: Internal.Runnable_): void;
        (arg0: Internal.Runnable): void;
    }
    type Executor_ = Executor;
    interface ThreadedAnvilChunkStorageAccessor {
        abstract getEntityTrackers(): Internal.Int2ObjectMap<Internal.EntityTrackerAccessor>;
        get entityTrackers(): Internal.Int2ObjectMap<Internal.EntityTrackerAccessor>
        (): Internal.Int2ObjectMap_<Internal.EntityTrackerAccessor>;
    }
    type ThreadedAnvilChunkStorageAccessor_ = ThreadedAnvilChunkStorageAccessor;
    class BogeyStyle$SizeRenderer extends Internal.Record {
        constructor(renderer: Internal.BogeyRenderer_, visualizer: Internal.BogeyVisualizer_)
        renderer(): Internal.BogeyRenderer;
        visualizer(): Internal.BogeyVisualizer;
    }
    type BogeyStyle$SizeRenderer_ = BogeyStyle$SizeRenderer;
    class MultifaceSpreader {
        constructor($$0: Internal.MultifaceBlock_)
        constructor($$0: any_)
        canSpreadInAnyDirection($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.Direction_): boolean;
        spreadAll($$0: Internal.BlockState_, $$1: Internal.LevelAccessor_, $$2: BlockPos_, $$3: boolean): number;
        spreadFromFaceTowardDirection($$0: Internal.BlockState_, $$1: Internal.LevelAccessor_, $$2: BlockPos_, $$3: Internal.Direction_, $$4: Internal.Direction_, $$5: boolean): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        getSpreadFromFaceTowardDirection($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.Direction_, $$4: Internal.Direction_, $$5: Internal.MultifaceSpreader$SpreadPredicate_): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        spreadFromRandomFaceTowardRandomDirection($$0: Internal.BlockState_, $$1: Internal.LevelAccessor_, $$2: BlockPos_, $$3: Internal.RandomSource_): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        spreadFromFaceTowardRandomDirection($$0: Internal.BlockState_, $$1: Internal.LevelAccessor_, $$2: BlockPos_, $$3: Internal.Direction_, $$4: Internal.RandomSource_, $$5: boolean): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        spreadToFace($$0: Internal.LevelAccessor_, $$1: Internal.MultifaceSpreader$SpreadPos_, $$2: boolean): Internal.Optional<Internal.MultifaceSpreader$SpreadPos>;
        static readonly DEFAULT_SPREAD_ORDER: any[];
    }
    type MultifaceSpreader_ = MultifaceSpreader;
    interface ChunkScanAccess {
        abstract scanChunk(arg0: Internal.ChunkPos_, arg1: Internal.StreamTagVisitor_): Internal.CompletableFuture<void>;
        (arg0: Internal.ChunkPos, arg1: Internal.StreamTagVisitor): Internal.CompletableFuture_<void>;
    }
    type ChunkScanAccess_ = ChunkScanAccess;
    class AllArmInteractionPointTypes$BasinType extends Internal.ArmInteractionPointType {
        constructor()
    }
    type AllArmInteractionPointTypes$BasinType_ = AllArmInteractionPointTypes$BasinType;
    interface IAgriFertilizable {
        abstract applyGrowthTick(): void;
        abstract acceptsFertilizer(arg0: Internal.AgriFertilizer_): boolean;
        onApplyFertilizer(fertilizer: Internal.AgriFertilizer_, rand: Internal.RandomSource_): void;
    }
    type IAgriFertilizable_ = IAgriFertilizable;
    class LayeredOreFeature extends Internal.Feature<Internal.LayeredOreConfiguration> {
        constructor()
        canPlaceOre(pState: Internal.BlockState_, pAdjacentStateAccessor: Internal.Function_<BlockPos, Internal.BlockState>, pRandom: Internal.RandomSource_, pConfig: Internal.LayeredOreConfiguration_, pTargetState: Internal.OreConfiguration$TargetBlockState_, pMatablePos: Internal.BlockPos$MutableBlockPos_): boolean;
    }
    type LayeredOreFeature_ = LayeredOreFeature;
    abstract class LongBuffer extends Internal.Buffer implements Internal.Comparable<Internal.LongBuffer> {
        rewind(): this;
        compareTo(arg0: any): number;
        get(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        abstract duplicate(): this;
        abstract order(): Internal.ByteOrder;
        mismatch(arg0: Internal.LongBuffer_): number;
        compareTo(arg0: Internal.LongBuffer_): number;
        abstract slice(): this;
        static wrap(arg0: number[], arg1: number, arg2: number): Internal.LongBuffer;
        put(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        abstract put(arg0: number, arg1: number): this;
        static allocate(arg0: number): Internal.LongBuffer;
        put(arg0: number, arg1: number[]): this;
        get(arg0: number, arg1: number[]): this;
        abstract get(): number;
        clear(): this;
        get(arg0: number[]): this;
        position(arg0: number): this;
        put(arg0: number[]): this;
        abstract put(arg0: number): this;
        mark(): this;
        abstract asReadOnlyBuffer(): this;
        put(arg0: number[], arg1: number, arg2: number): this;
        static wrap(arg0: number[]): Internal.LongBuffer;
        put(arg0: Internal.LongBuffer_): this;
        put(arg0: number, arg1: Internal.LongBuffer_, arg2: number, arg3: number): this;
        abstract get(arg0: number): number;
        array(): number[];
        get(arg0: number[], arg1: number, arg2: number): this;
        abstract compact(): this;
    }
    type LongBuffer_ = LongBuffer;
    class SpecializedRepairRecipeSerializer <T extends Internal.Recipe<any> & Internal.SpecializedRepairRecipeSerializer$ISpecializedRepairRecipe> extends Internal.LoggingRecipeSerializer<T> {
        constructor(factory: any_<T>)
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): T;
    }
    type SpecializedRepairRecipeSerializer_<T extends Internal.Recipe<any> & Internal.SpecializedRepairRecipeSerializer$ISpecializedRepairRecipe> = SpecializedRepairRecipeSerializer<T>;
    class GameConfig$UserData {
        constructor($$0: Internal.User_, $$1: Internal.PropertyMap_, $$2: Internal.PropertyMap_, $$3: Internal.Proxy_)
        readonly user: Internal.User;
        readonly userProperties: Internal.PropertyMap;
        readonly proxy: Internal.Proxy;
        readonly profileProperties: Internal.PropertyMap;
    }
    type GameConfig$UserData_ = GameConfig$UserData;
    class BlockAkashicLog extends Internal.BlockAxis {
        constructor(props: Internal.BlockBehaviour$Properties_)
        isFlammable(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getFireSpreadSpeed(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): number;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getFlammability(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, direction: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockAkashicLog_ = BlockAkashicLog;
    class ModifiableBowItem extends Internal.ModifiableLauncherItem {
        constructor(properties: Internal.Item$Properties_, toolDefinition: Internal.ToolDefinition_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static getDisplayStack(item: Internal.Item_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLocalizedName(): net.minecraft.network.chat.Component;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getStatInformation(tool: Internal.IToolStackView_, player: Internal.Player_, tooltips: Internal.List_<net.minecraft.network.chat.Component>, key: Internal.TooltipKey_, tooltipFlag: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        /**
         * @deprecated
        */
        getStatInformation(tool: Internal.IToolStackView_, player: Internal.Player_, tooltips: Internal.List_<net.minecraft.network.chat.Component>, key: slimeknights.tconstruct.library.utils.TooltipKey_, tooltipFlag: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        setAttackDamage(attackDamage: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static setRarity(volatileData: Internal.ModDataNBT_, rarity: Internal.Rarity_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get localizedName(): net.minecraft.network.chat.Component
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ModifiableBowItem_ = ModifiableBowItem;
    class MatrixFrameBlock extends Internal.AEBaseBlock {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type MatrixFrameBlock_ = MatrixFrameBlock;
    interface LootContextExtensions {
        getLootingModifier(): number;
        setQueriedLootTableId(queriedLootTableId: ResourceLocation_): void;
        getQueriedLootTableId(): ResourceLocation;
        get lootingModifier(): number
        set queriedLootTableId(queriedLootTableId: ResourceLocation_)
        get queriedLootTableId(): ResourceLocation
    }
    type LootContextExtensions_ = LootContextExtensions;
    class SlidingDoorBlock extends Internal.DoorBlock implements Internal.IBE<Internal.SlidingDoorBlockEntity>, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IHaveBigOutline {
        constructor(properties: Internal.BlockBehaviour$Properties_, type: Internal.BlockSetType_, folds: boolean)
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.SlidingDoorBlockEntity>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.SlidingDoorBlockEntity>): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.SlidingDoorBlockEntity>;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.SlidingDoorBlockEntity;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        static isDoorPowered(pLevel: Internal.Level_, pPos: BlockPos_, state: Internal.BlockState_): boolean;
        setRequiresTool(v: boolean): void;
        deferUpdate(level: Internal.LevelAccessor_, pos: BlockPos_): void;
        isFoldingDoor(): boolean;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        static stone(properties: Internal.BlockBehaviour$Properties_, folds: boolean): Internal.SlidingDoorBlock;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        static glass(properties: Internal.BlockBehaviour$Properties_, folds: boolean): Internal.SlidingDoorBlock;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.SlidingDoorBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static isDoubleDoor(pState: Internal.BlockState_, hinge: Internal.DoorHingeSide_, facing: Internal.Direction_, otherDoor: Internal.BlockState_): boolean;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityClass(): typeof Internal.SlidingDoorBlockEntity;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static metal(properties: Internal.BlockBehaviour$Properties_, folds: boolean): Internal.SlidingDoorBlock;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityType(): Internal.BlockEntityType<Internal.SlidingDoorBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get foldingDoor(): boolean
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.SlidingDoorBlockEntity
        static readonly TRAIN_SET_TYPE: Internal.Supplier<Internal.BlockSetType>;
        static readonly GLASS_SET_TYPE: Internal.Supplier<Internal.BlockSetType>;
        static readonly STONE_SET_TYPE: Internal.Supplier<Internal.BlockSetType>;
        static readonly VISIBLE: Internal.BooleanProperty;
    }
    type SlidingDoorBlock_ = SlidingDoorBlock;
    class Direction extends Internal.Enum<Internal.Direction> implements Internal.StringRepresentable {
        static fromYRot($$0: number): Internal.Direction;
        static valueOf($$0: string): Internal.Direction;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getX(): number;
        getY(): number;
        getNormal(): Vec3i;
        getHorizontalIndex(): number;
        getSerializedName(): string;
        getIndex(): number;
        getClockWise(): this;
        static getNearest($$0: number, $$1: number, $$2: number): Internal.Direction;
        getAxis(): Internal.Direction$Axis;
        static getRandom(rand: Internal.RandomSource_): Internal.Direction;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static orderedByNearest($$0: Internal.Entity_): Internal.Direction[];
        getClockWise($$0: Internal.Direction$Axis_): this;
        getPitch(): number;
        static getFacingAxis($$0: Internal.Entity_, $$1: Internal.Direction$Axis_): Internal.Direction;
        static values(): Internal.Direction[];
        static fromDelta($$0: number, $$1: number, $$2: number): Internal.Direction;
        getName(): string;
        getZ(): number;
        static fromAxisAndDirection($$0: Internal.Direction$Axis_, $$1: Internal.Direction$AxisDirection_): Internal.Direction;
        getOpposite(): this;
        static from2DDataValue($$0: number): Internal.Direction;
        step(): Vec3f;
        static stream(): Internal.Stream<Internal.Direction>;
        getAxisDirection(): Internal.Direction$AxisDirection;
        static from3DDataValue($$0: number): Internal.Direction;
        getCounterClockWise($$0: Internal.Direction$Axis_): this;
        static rotate($$0: Matrix4f_, $$1: Internal.Direction_): Internal.Direction;
        isFacingAngle($$0: number): boolean;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static getNearest(x: number, y: number, z: number): Internal.Direction;
        static byName($$0: string): Internal.Direction;
        getYaw(): number;
        static allShuffled($$0: Internal.RandomSource_): Internal.Collection<Internal.Direction>;
        getRotation(): Quaternionf;
        static get($$0: Internal.Direction$AxisDirection_, $$1: Internal.Direction$Axis_): Internal.Direction;
        getCounterClockWise(): this;
        get x(): number
        get y(): number
        get normal(): Vec3i
        get horizontalIndex(): number
        get serializedName(): string
        get index(): number
        get clockWise(): Internal.Direction
        get axis(): Internal.Direction$Axis
        get pitch(): number
        get name(): string
        get z(): number
        get opposite(): Internal.Direction
        get axisDirection(): Internal.Direction$AxisDirection
        get yaw(): number
        get rotation(): Quaternionf
        get counterClockWise(): Internal.Direction
        static readonly UP: Internal.Direction;
        static readonly NORTH: Internal.Direction;
        static readonly DOWN: Internal.Direction;
        static readonly EAST: Internal.Direction;
        static readonly WEST: Internal.Direction;
        static readonly CODEC: Internal.StringRepresentable$EnumCodec<Internal.Direction>;
        static readonly SOUTH: Internal.Direction;
        static readonly VERTICAL_CODEC: Internal.Codec<Internal.Direction>;
    }
    type Direction_ = "west" | "east" | "south" | "up" | "down" | "north" | Direction;
    class SpawnData extends Internal.Record {
        constructor()
        constructor($$0: Internal.CompoundTag_, $$1: Internal.Optional_<Internal.SpawnData$CustomSpawnRules>)
        customSpawnRules(): Internal.Optional<Internal.SpawnData$CustomSpawnRules>;
        getEntityToSpawn(): Internal.CompoundTag;
        getCustomSpawnRules(): Internal.Optional<Internal.SpawnData$CustomSpawnRules>;
        entityToSpawn(): Internal.CompoundTag;
        get entityToSpawn(): Internal.CompoundTag
        get customSpawnRules(): Internal.Optional<Internal.SpawnData$CustomSpawnRules>
        static readonly LIST_CODEC: Internal.Codec<Internal.SimpleWeightedRandomList<Internal.SpawnData>>;
        static readonly CODEC: Internal.Codec<Internal.SpawnData>;
        static readonly ENTITY_TAG: "entity";
    }
    type SpawnData_ = SpawnData;
    class ArchitecturySpawnEggItem extends Internal.SpawnEggItem {
        constructor(entityType: Internal.RegistrySupplier_<Internal.EntityType<Internal.Mob>>, backgroundColor: number, highlightColor: number, properties: Internal.Item$Properties_, dispenseItemBehavior: Internal.DispenseItemBehavior_)
        constructor(entityType: Internal.RegistrySupplier_<Internal.EntityType<Internal.Mob>>, backgroundColor: number, highlightColor: number, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static getEggMap(): Internal.Map<Internal.EntityType<any>, Internal.SpawnEggItem>;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get eggMap(): Internal.Map<Internal.EntityType<any>, Internal.SpawnEggItem>
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ArchitecturySpawnEggItem_ = ArchitecturySpawnEggItem;
    interface MemoryTrackingBuffer {
        abstract freeAndDeleteBuffer(): void;
        abstract getUsedSize(): number;
        abstract getAllocatedSize(): number;
        get usedSize(): number
        get allocatedSize(): number
    }
    type MemoryTrackingBuffer_ = MemoryTrackingBuffer;
    class BigTreeFeature extends Internal.BOPTreeFeature<any> {
        constructor(codec: Internal.Codec_<any>)
    }
    type BigTreeFeature_ = BigTreeFeature;
    class AnnihilationPlanePartItem extends Internal.PartItem<any> {
        constructor(properties: Internal.Item$Properties_)
        static getId(item: Internal.IPartItem_<any>): ResourceLocation;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        static byId(id: ResourceLocation_): Internal.IPartItem<any>;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static byNetworkId(id: number): Internal.IPartItem<any>;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        static getNetworkId(item: Internal.IPartItem_<any>): number;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly CALLING_DAMAGEABLE_FROM_ANVIL: Internal.ThreadLocal<any>;
    }
    type AnnihilationPlanePartItem_ = AnnihilationPlanePartItem;
    class StarLightInterface {
        constructor(lightAccess: Internal.LightChunkGetter_, hasSkyLight: boolean, hasBlockLight: boolean, lightEngine: Internal.LevelLightEngine_)
        getLightAccess(): Internal.LightChunkGetter;
        propagateChanges(): void;
        getWorld(): Internal.Level;
        checkSkyEdges(chunkX: number, chunkZ: number, sections: Internal.ShortCollection_): void;
        isClientSide(): boolean;
        hasUpdates(): boolean;
        hasSkyLight(): boolean;
        getSkyReader(): Internal.LayerLightEventListener;
        scheduleChunkLight(pos: Internal.ChunkPos_, run: Internal.Runnable_): void;
        forceLoadInChunk(chunk: Internal.ChunkAccess_, emptySections: boolean[]): void;
        sectionChange(pos: Internal.SectionPos_, newEmptyValue: boolean): Internal.CompletableFuture<void>;
        blockChange(pos: BlockPos_): Internal.CompletableFuture<void>;
        lightChunk(chunk: Internal.ChunkAccess_, emptySections: boolean[]): void;
        removeChunkTasks(pos: Internal.ChunkPos_): void;
        loadInChunk(chunkX: number, chunkZ: number, emptySections: boolean[]): void;
        getBlockReader(): Internal.LayerLightEventListener;
        hasBlockLight(): boolean;
        checkSkyEdges(chunkX: number, chunkZ: number): void;
        checkBlockEdges(chunkX: number, chunkZ: number): void;
        relightChunks(chunks: Internal.Set_<Internal.ChunkPos>, chunkLightCallback: Internal.Consumer_<Internal.ChunkPos>, onComplete: Internal.IntConsumer_): void;
        checkBlockEdges(chunkX: number, chunkZ: number, sections: Internal.ShortCollection_): void;
        getRawBrightness(pos: BlockPos_, ambientDarkness: number): number;
        getAnyChunkNow(chunkX: number, chunkZ: number): Internal.ChunkAccess;
        checkChunkEdges(chunkX: number, chunkZ: number): void;
        get lightAccess(): Internal.LightChunkGetter
        get world(): Internal.Level
        get clientSide(): boolean
        get skyReader(): Internal.LayerLightEventListener
        get blockReader(): Internal.LayerLightEventListener
        static readonly CHUNK_WORK_TICKET: Internal.TicketType<Internal.ChunkPos>;
        readonly lightEngine: Internal.LevelLightEngine;
    }
    type StarLightInterface_ = StarLightInterface;
    class BlockPixieHouse extends Internal.BaseEntityBlock {
        constructor()
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, entityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static name(type: string): string;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        dropPixie(world: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.DirectionProperty;
    }
    type BlockPixieHouse_ = BlockPixieHouse;
    class Rotation extends Internal.Enum<Internal.Rotation> implements Internal.StringRepresentable {
        static getRandom($$0: Internal.RandomSource_): Internal.Rotation;
        rotate($$0: Internal.Direction_): Internal.Direction;
        static valueOf($$0: string): Internal.Rotation;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        rotation(): Internal.OctahedralGroup;
        static values(): Internal.Rotation[];
        getRotated($$0: Internal.Rotation_): this;
        rotate($$0: number, $$1: number): number;
        static getShuffled($$0: Internal.RandomSource_): Internal.List<Internal.Rotation>;
        get serializedName(): string
        static readonly CODEC: Internal.Codec<Internal.Rotation>;
        static readonly NONE: Internal.Rotation;
        static readonly CLOCKWISE_90: Internal.Rotation;
        static readonly CLOCKWISE_180: Internal.Rotation;
        static readonly COUNTERCLOCKWISE_90: Internal.Rotation;
    }
    type Rotation_ = "clockwise_90" | "clockwise_180" | "counterclockwise_90" | Rotation | "none";
    class SeaSerpent {
        constructor(name: string, color: Internal.ChatFormatting_)
        getName(): string;
        getTexture(blink: boolean): ResourceLocation;
        getColor(): Internal.ChatFormatting;
        static getByName(name: string): Internal.SeaSerpent;
        static initArmors(): void;
        static values(): Internal.List<Internal.SeaSerpent>;
        get name(): string
        get color(): Internal.ChatFormatting
        static readonly GREEN: Internal.SeaSerpent;
        scaleBlock: Internal.RegistrySupplier<Internal.Block>;
        scale: Internal.RegistrySupplier<Internal.Item>;
        static readonly TEAL: Internal.SeaSerpent;
        static readonly DEEPBLUE: Internal.SeaSerpent;
        chestplate: Internal.RegistrySupplier<Internal.Item>;
        helmet: Internal.RegistrySupplier<Internal.Item>;
        static readonly PURPLE: Internal.SeaSerpent;
        static readonly BLUE: Internal.SeaSerpent;
        static readonly BRONZE: Internal.SeaSerpent;
        armorMaterial: Internal.CustomArmorMaterial;
        leggings: Internal.RegistrySupplier<Internal.Item>;
        boots: Internal.RegistrySupplier<Internal.Item>;
        static readonly RED: Internal.SeaSerpent;
    }
    type SeaSerpent_ = SeaSerpent;
    interface NonNullSupplier <T> extends Internal.Supplier<T> {
        of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): this;
        lazy(): this;
        of<T>(sup: Internal.Supplier_<T>): this;
        abstract get(): T;
        lazy<T>(sup: Internal.Supplier_<T>): this;
        (): T;
    }
    type NonNullSupplier_<T> = NonNullSupplier<T>;
    class HeaterBlock extends Internal.ControllerBlock {
        constructor(builder: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type HeaterBlock_ = HeaterBlock;
    class ResourceArgument <T> implements Internal.ArgumentType<Internal.Holder$Reference<T>> {
        constructor($$0: Internal.CommandBuildContext_, $$1: Internal.ResourceKey_<Internal.Registry<T>>)
        static getConfiguredFeature($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Holder$Reference<Internal.ConfiguredFeature<any, any>>;
        listSuggestions<S>($$0: Internal.CommandContext_<S>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        static resource<T>($$0: Internal.CommandBuildContext_, $$1: Internal.ResourceKey_<Internal.Registry<T>>): Internal.ResourceArgument<T>;
        getExamples(): Internal.Collection<string>;
        static getResource<T>($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string, $$2: Internal.ResourceKey_<Internal.Registry<T>>): Internal.Holder$Reference<T>;
        static getSummonableEntityType($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Holder$Reference<Internal.EntityType<any>>;
        static getMobEffect($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Holder$Reference<Internal.MobEffect>;
        static getStructure($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Holder$Reference<Internal.Structure>;
        static getEnchantment($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Holder$Reference<Internal.Enchantment>;
        static getEntityType($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Holder$Reference<Internal.EntityType<any>>;
        parse($$0: Internal.StringReader_): Internal.Holder$Reference<T>;
        parse(arg0: Internal.StringReader_): any;
        static getAttribute($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Holder$Reference<Internal.Attribute>;
        get examples(): Internal.Collection<string>
        static readonly ERROR_UNKNOWN_RESOURCE: Internal.Dynamic2CommandExceptionType;
        static readonly ERROR_INVALID_RESOURCE_TYPE: Internal.Dynamic3CommandExceptionType;
    }
    type ResourceArgument_<T> = ResourceArgument<T>;
    class MountedFluidStorageWrapper extends Internal.CombinedStorage<Internal.FluidVariant, Internal.MountedFluidStorage> {
        constructor(storages: Internal.ImmutableMap_<BlockPos, Internal.MountedFluidStorage>)
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.FluidVariant>>;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.FluidVariant_): Internal.StorageView<Internal.FluidVariant>;
        static empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        static asClass<T>(): Internal.Storage<T>;
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.FluidVariant>>;
        get version(): number
        readonly storages: Internal.ImmutableMap<BlockPos, Internal.MountedFluidStorage>;
    }
    type MountedFluidStorageWrapper_ = MountedFluidStorageWrapper;
    class FaucetBlock extends Internal.Block implements Internal.EntityBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(pPos: BlockPos_, pState: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(pLevel: Internal.Level_, pState: Internal.BlockState_, type: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.DirectionProperty;
    }
    type FaucetBlock_ = FaucetBlock;
    class FeaturePoolElement extends Internal.StructurePoolElement {
        static readonly CODEC: Internal.Codec<Internal.FeaturePoolElement>;
    }
    type FeaturePoolElement_ = FeaturePoolElement;
    class EnumGetMethod extends Internal.Enum<Internal.EnumGetMethod> {
        isCaseSensitive(): boolean;
        static values(): Internal.EnumGetMethod[];
        isOrdinalOk(): boolean;
        validate<T extends Internal.Enum<T>>(value: any, enumType: T): boolean;
        get<T extends Internal.Enum<T>>(value: any, enumType: T): T;
        static valueOf(name: string): Internal.EnumGetMethod;
        get caseSensitive(): boolean
        get ordinalOk(): boolean
        static readonly ORDINAL_OR_NAME: Internal.EnumGetMethod;
        static readonly ORDINAL_OR_NAME_IGNORECASE: Internal.EnumGetMethod;
        static readonly NAME: Internal.EnumGetMethod;
        static readonly NAME_IGNORECASE: Internal.EnumGetMethod;
    }
    type EnumGetMethod_ = "name" | "ordinal_or_name" | EnumGetMethod | "ordinal_or_name_ignorecase" | "name_ignorecase";
}
